"use client"
import { Tabs, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { routing } from "@/config/site";
import { useRouter } from "@/lib/navigation.router";
import { usePathname } from "next/navigation";

export function LayoutTabs() {
  const path = usePathname()
  const router = useRouter()

  return (
    <Tabs
      className="mb-4"
      defaultValue={path}
      onValueChange={(v) => {
        const isActive = path === v;
        if (isActive) {
          return;
        }

        router.push(v)
      }}
    >
      <TabsList>
        {routing.settings.map((s) => {
          if (!s.enabled) {
            return null;
          }

          return (
            <TabsTrigger
              key={s.url}
              value={s.url}
              className="flex flex-row gap-1 justify-center"
            >
              {s.icon}
              {s.title}
            </TabsTrigger>
          )
        })
        }
      </TabsList>
    </Tabs>
  )
}
